function [a]=sens_plot2(skt,n)
  if (nargin==1)
    n=1000;
  end
 sinlength=10000.0/32768.0;
pos=[];
a=zeros(1,n);
[a,ptr]=GetSensData(skt,a,1);
a=zeros(1,n);
[a,ptr]=GetSensData(skt,a,ptr);
%measure is signed - so convert from unsigned to signed
pos=a;
idx=find(pos>32767.0);
pos(idx)=pos(idx)-65536;
pos=pos*sinlength;
phdl=plot(pos);
s=sprintf('mean pos= %2.4fmm  rms=%2.4fmm',mean(pos),sqrt(var(pos)));
ylabel('um');
thdl=title(s);
grid on;
while (size(kbhit(1))(1)<1) 
  [a,ptr]=GetSensData(skt,a,ptr);
  pos=a;
  idx=find(pos>32767.0);
  pos(idx)=pos(idx)-65536;
  pos=pos*sinlength;
  set(phdl,'ydata',pos);
  set(thdl,'string',sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos))));
  drawnow;
  end
end
  